/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.arc;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.api.compat.EnumDemonWillType;
import wayoftime.bloodmagic.common.item.arc.IARCTool;
import wayoftime.bloodmagic.util.ChatUtil;

public class ItemARCToolBase
extends Item
implements IARCTool {
    private final double craftingMultiplier;
    private final double additionalOutputChance;
    private final EnumDemonWillType dominantWillType;

    public ItemARCToolBase(int maxDamage, double craftingMultiplier) {
        this(maxDamage, craftingMultiplier, 1.0);
    }

    public ItemARCToolBase(int maxDamage, double craftingMultiplier, EnumDemonWillType type) {
        this(maxDamage, craftingMultiplier, 1.0, type);
    }

    public ItemARCToolBase(int maxDamage, double craftingMultiplier, double additionalOutputChance) {
        this(maxDamage, craftingMultiplier, additionalOutputChance, EnumDemonWillType.DEFAULT);
    }

    public ItemARCToolBase(int maxDamage, double craftingMultiplier, double additionalOutputChance, EnumDemonWillType type) {
        super(new Item.Properties().m_41487_(1).m_41491_(BloodMagic.TAB).m_41503_(maxDamage));
        this.craftingMultiplier = craftingMultiplier;
        this.additionalOutputChance = additionalOutputChance;
        this.dominantWillType = type;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.arctool.uses", new Object[]{stack.m_41776_() - stack.m_41773_()}).m_130940_(ChatFormatting.GRAY));
        if (this.getCraftingSpeedMultiplier(stack) != 1.0) {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.arctool.craftspeed", new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getCraftingSpeedMultiplier(stack))}).m_130940_(ChatFormatting.GRAY));
        }
        if (this.getAdditionalOutputChanceMultiplier(stack) != 1.0) {
            tooltip.add((Component)new TranslatableComponent("tooltip.bloodmagic.arctool.additionaldrops", new Object[]{ChatUtil.DECIMAL_FORMAT.format(this.getAdditionalOutputChanceMultiplier(stack))}).m_130940_(ChatFormatting.GRAY));
        }
        super.m_7373_(stack, world, tooltip, flag);
    }

    @Override
    public double getCraftingSpeedMultiplier(ItemStack stack) {
        return this.craftingMultiplier;
    }

    @Override
    public double getAdditionalOutputChanceMultiplier(ItemStack stack) {
        return this.additionalOutputChance;
    }

    @Override
    public EnumDemonWillType getDominantWillType(ItemStack stack) {
        return this.dominantWillType;
    }
}

